/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	Header File for Line Convenience Functions.

#pragma once

HRESULT __declspec(dllexport) CreateLine(double startX, double startY, double endX, double endY,
				   ILine **line1) ;

HRESULT __declspec(dllexport) CreateCircle(double centerX, double centerY, double radius,
					 ILine **circle1) ;

HRESULT __declspec(dllexport) CreateRectangle(double topLeftX, double topLeftY, double bottomRightX,
						double bottomRightY, ISet **rectangle1) ;

HRESULT __declspec(dllexport) CreateArcStartEndCenter(IPoint *startPoint, IPoint *endPoint,
								IPoint *center, ILine **arc1) ;

HRESULT __declspec(dllexport) CreateLinePointToPoint(IPoint *point1, IPoint *point2, ILine **line1) ;

HRESULT __declspec(dllexport) CreateLineStartToStart(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllexport) CreateLineStartToMiddle(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllexport) CreateLineStartToEnd(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllexport) CreateLineMiddleToStart(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllexport) CreateLineMiddleToMiddle(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllexport) CreateLineMiddleToEnd(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllexport) CreateLineEndToStart(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllexport) CreateLineEndToMiddle(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllexport) CreateLineEndToEnd(ILine *line1, ILine *line2, ILine **newLine1) ;

HRESULT __declspec(dllexport) CreateLineCenterToStart(ILine *circle1, ILine *line1,
								ILine **newLine1) ;

HRESULT __declspec(dllexport) CreateLineCenterToMiddle(ILine *circle1, ILine *line1,
								 ILine **newLine1) ;

HRESULT __declspec(dllexport) CreateLineCenterToEnd(ILine *circle1, ILine *line1,
							  ILine **newLine1) ;

HRESULT __declspec(dllexport) CreateLineStartToCenter(ILine *line1, ILine *circle1,
								ILine **newLine1) ;

HRESULT __declspec(dllexport) CreateLineMiddleToCenter(ILine *line1, ILine *circle1,
								 ILine **newLine1) ;

HRESULT __declspec(dllexport) CreateLineEndToCenter(ILine *line1, ILine *circle1,
							  ILine **newLine1) ;

HRESULT __declspec(dllexport) CreateLineCenterToCenter(ILine *circle1, ILine *circle2,
								 ILine **newLine1) ;

HRESULT __declspec(dllexport) GetMidPoint(ILine *line1, IPoint **point1) ;